// XISLEndTag.cpp: CXISLEndTag NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ib.h"
#include "XISLEndTag.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CXISLEndTag::CXISLEndTag(CXISLTag *pParent)
{
	m_pParentTag = pParent;

	m_nTagType = ID_TAG_END;
	m_nBmpID = IDB_END;

	m_pXISLAct = NULL;
}

CXISLEndTag::CXISLEndTag(const CXISLEndTag &cpXISL)
{
	m_nTagType = cpXISL.m_nTagType;
	m_strXISL = cpXISL.m_strXISL;
	m_rectBMP = cpXISL.m_rectBMP;
	m_nBmpID = cpXISL.m_nBmpID;
	m_htreeItem = cpXISL.m_htreeItem;
	m_pParentTag = cpXISL.m_pParentTag;

	m_pXISLAct = cpXISL.m_pXISLAct;
}


CXISLEndTag::~CXISLEndTag()
{
	if(m_pXISLAct)
		delete m_pXISLAct;
}

CXISLEndTag& CXISLEndTag::operator=(const CXISLEndTag &cpXISL)
{
	if(&cpXISL != this)
	{
		m_nTagType = cpXISL.m_nTagType;
		m_strXISL = cpXISL.m_strXISL;
		m_rectBMP = cpXISL.m_rectBMP;
		m_nBmpID = cpXISL.m_nBmpID;
		m_htreeItem = cpXISL.m_htreeItem;
		m_pParentTag = cpXISL.m_pParentTag;

		m_pXISLAct = cpXISL.m_pXISLAct;
	}
	return *this;
}


//LPCTSTR CXISLEndTag::GetXISLString()
//@\@FbeginȉXISLԂ
//@F
//ԂlFLPCTSTRCXISL
LPCTSTR CXISLEndTag::GetXISLString()
{
	m_strXISL = "<end>\r\n";
	
	if(m_pXISLAct)
		m_strXISL += m_pXISLAct->GetXISLString();

	m_strXISL += "</end>\r\n";
	return m_strXISL;
}

//int CXISLEndTag::GetItemCount()
//@\@FbeginȉXISL̃c[ڐԂ
//@F
//߂lFintCc[ڐ
int CXISLEndTag::GetItemCount()
{
	int nCount;
	if(m_pXISLAct)
		nCount = m_pXISLAct->GetItemCount();

	nCount++; //<exchange>̕
	return nCount;
}


//BOOL CXISLEndTag::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
//@\@Fc[Rg[XISL^Oo^
//@FCTreeCtrl *pTree  :o^c[Rg[
//		  HTREEITEM hParent :eڂ̃nh
//ԂlFBOOL@FTRUE@sFFALSE
BOOL CXISLEndTag::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
{
	TVINSERTSTRUCTA tvs;
	TVITEMA tvi;

	tvs.hInsertAfter = TVI_LAST;
	tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvs.hParent = hParent;

	//c[ɓo^
	tvi.pszText = XISL_TAG_NAME[ID_TAG_END];
	tvi.lParam = (LPARAM)this;
	tvi.iImage = 0;
	tvi.iSelectedImage = 1;
	tvs.item = tvi;
	hParent = pTree->InsertItem(&tvs);
	m_htreeItem = hParent;

	if(m_pXISLAct)
		m_pXISLAct->RegistXISLTree(pTree,hParent);

	return TRUE;
}
